//texture tex0 < string name = "sdf"; >;	// Base texture
//texture tex1 < string name = "sdf"; >;	// Base texture

float4x4 WorldViewProjectionMatrix; 
float4	 FlagCoords;

sampler BaseTexture  =
sampler_state
{
##	Texture = <tex0>;
	MinFilter = Nearest;
	MagFilter = Nearest;
	WrapS = Repeat;
	WrapT = Repeat;
};

sampler MaskTexture  =
sampler_state
{
##	Texture = <tex1>;
	MinFilter = Nearest;
	MagFilter = Nearest;
	WrapS = Repeat;
	WrapT = Repeat;
};

struct VS_INPUT
{
    float4 vPosition  : POSITION;
    float2 vTexCoord  : TEXCOORD0;
    float2 vMaskCoord  : TEXCOORD1;
};

struct VS_OUTPUT
{
    float4  vPosition : POSITION;
    float2  vTexCoord0 : TEXCOORD0;
    float2  vTexCoord1 : TEXCOORD1;
};


VS_OUTPUT VertexShader_(const VS_INPUT v )
{
	VS_OUTPUT Out = (VS_OUTPUT)0;

	Out.vPosition  = mul(v.vPosition, WorldViewProjectionMatrix );

	Out.vTexCoord1 = v.vMaskCoord;
	float2 texCoord = v.vTexCoord;

	Out.vTexCoord0.x = texCoord.x/FlagCoords.x;
	Out.vTexCoord0.x = Out.vTexCoord0.x + FlagCoords.z;
	Out.vTexCoord0.y = texCoord.y/FlagCoords.y;
	Out.vTexCoord0.y = Out.vTexCoord0.y + FlagCoords.w;

	return Out;
}

float4 PixelShader_( VS_OUTPUT v ) : COLOR
{
	float4 OutColor = tex2D( BaseTexture, v.vTexCoord0.xy );
	float4 MaskColor = tex2D( MaskTexture, v.vTexCoord1.xy );
	OutColor.a = MaskColor.a;
	
	return OutColor;
}

float4 PixelShaderOver( VS_OUTPUT v ) : COLOR
{
    float4 OutColor = tex2D( BaseTexture, v.vTexCoord0.xy );
    float4 MaskColor = tex2D( MaskTexture, v.vTexCoord1.xy );
    float4 MixColor = float4( 0.1, 0.1, 0.1, 0 );
    OutColor.a = MaskColor.a;
    OutColor += MixColor;

    return OutColor;
}

float4 PixelShaderDown( VS_OUTPUT v ) : COLOR
{
    float4 OutColor = tex2D( BaseTexture, v.vTexCoord0.xy );
    float4 MaskColor = tex2D( MaskTexture, v.vTexCoord1.xy );
    float4 MixColor = float4( 0.1, 0.1, 0.1, 0 );
    OutColor.a = MaskColor.a;
    OutColor += (-MixColor);

    return OutColor;
}

float4 PixelShaderDisable( VS_OUTPUT v ) : COLOR
{
    float4 OutColor = tex2D( BaseTexture, v.vTexCoord0.xy );
//  float4 MaskColor = texRECT( MaskTexture, v.vTexCoord1.xy );
    float4 MaskColor = tex2D( MaskTexture, v.vTexCoord1.xy );
    float Grey = dot( OutColor.rgb, float3( 0.212671f, 0.715160f, 0.072169f ) ); 
    
    OutColor.rgb = Grey;
    OutColor.a = MaskColor.a;

    return OutColor;
}

technique tec0
{
	pass p0
	{
//TODO		fvf = XYZ | Normal | Diffuse | Tex1;

		LightEnable[0] = false;
		LightingEnable = false;

		BlendEnable = true;

//TODO		Texture[0] = <tex0>;

//TODO		ColorOp[0] = Modulate;
//TODO		ColorArg1[0] = Texture;
//TODO		ColorArg2[0] = current;
  
//TODO		ColorOp[1] = Disable;
//TODO		AlphaOp[1] = Disable;

		VertexProgram = compile arbvp1 VertexShader_();
		FragmentProgram = compile arbfp1 PixelShader_();
	}
}

technique down
{
	pass p0
	{
//TODO		fvf = XYZ | Tex1;

		LightEnable[0] = false;
		LightingEnable = false;

		BlendEnable = true;

//TODO		Texture[0] = <tex0>;


//TODO		ColorOp[0] = Modulate;
//TODO		ColorArg1[0] = Texture;
//TODO		ColorArg2[0] = current;
  
//TODO		ColorOp[1] = Disable;
//TODO		AlphaOp[1] = Disable;

//		VertexShaderConstant[4] = (WorldViewProjectionMatrix); // World*View*Proj Matrix

		VertexProgram = compile arbvp1 VertexShader_();
		FragmentProgram = compile arbfp1 PixelShaderDown();
	}
}

technique over
{
	pass p0
	{
//TODO		fvf = XYZ | Tex1;

		LightEnable[0] = false;
		LightingEnable = false;

		BlendEnable = true;

//TODO		Texture[0] = <tex0>;


//TODO		ColorOp[0] = Modulate;
//TODO		ColorArg1[0] = Texture;
//TODO		ColorArg2[0] = current;
  
//TODO		ColorOp[1] = Disable;
//TODO		AlphaOp[1] = Disable;

//		VertexShaderConstant[4] = (WorldViewProjectionMatrix); // World*View*Proj Matrix

		VertexProgram = compile arbvp1 VertexShader_();
		FragmentProgram = compile arbfp1 PixelShaderOver();
	}
}

technique disable
{
	pass p0
	{
//TODO		fvf = XYZ | Tex1;

		LightEnable[0] = false;
		LightingEnable = false;

		BlendEnable = true;

//TODO		Texture[0] = <tex0>;


//TODO		ColorOp[0] = Modulate;
//TODO		ColorArg1[0] = Texture;
//TODO		ColorArg2[0] = current;
  
//TODO		ColorOp[1] = Disable;
//TODO		AlphaOp[1] = Disable;

//		VertexShaderConstant[4] = (WorldViewProjectionMatrix); // World*View*Proj Matrix

		VertexProgram = compile arbvp1 VertexShader_();
		FragmentProgram = compile arbfp1 PixelShaderDisable();
	}
}
